/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260.DeviceView;

import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm8260.DeviceView.Port;
import ibm.nways.jdm8260.MibValue;
import ibm.nways.ras.RAS;
import java.io.Serializable;

public class PortCACarrier
extends Port {
    protected String macAddressString;

    public void setSpecificInformation() {
        super.setSpecificInformation();
        this.hub.askMACAddress(this);
    }

    public boolean findMACAddress() {
        String string = null;
        if (this.modType >= 167001 && this.modType <= 167999) {
            string = "oc64nnM-carrier-GG2-CAPortMacAddr";
        }
        if (this.modType < 138001 || this.modType > 138999) {
            return false;
        }
        string = "aCAR-CAPortMacAddr";
        Serializable serializable = this.hub.getMibInfo().getVar(string, "." + this.slot + "." + this.portNumber);
        if (serializable instanceof MibValue) {
            this.macAddressString = ((MibValue)serializable).getValue().toString();
            if (this.macAddressString.equals("")) {
                this.macAddressString = null;
                return false;
            }
            return true;
        }
        return false;
    }

    public I18NMsgFormat getFlyOverText() {
        String string = "getFlyOverText";
        if (this.macAddressString == null) {
            return super.getFlyOverText();
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = new Integer(this.portNumber);
        String string2 = "Port_unspecified_conn";
        try {
            string2 = Port.PORT_TYPE[this.portType];
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string, "Cannot find fly-over for port type -> " + this.portType);
            }
            RAS.logException(19, 2, this, string, exception);
        }
        objectArray[1] = this.hub.getBundle().getString(string2);
        objectArray[2] = this.macAddressString;
        return new I18NMsgFormat("ibm.nways.jdm8260.DeviceView.GraphicResources", "PortWithMac", objectArray);
    }
}

